import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.Name;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.response.AuthToken;
import org.uddi4j.response.BusinessDetail;
import org.uddi4j.response.BusinessInfo;
import org.uddi4j.response.BusinessInfos;
import org.uddi4j.response.BusinessList;
import org.uddi4j.transport.TransportFactory;
import java.security.Security;
import java.util.Vector;

public class UDDISaveBusiness1 {

	public static void main(String[] args) throws Exception {

		System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");      
		Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");
		proxy.setPublishURL("https://uddi.microsoft.com/publish");

		AuthToken at = proxy.get_authToken("user", "password");

		BusinessEntity be = new BusinessEntity("", "Services Web & compagnie");

		Vector entities = new Vector();
		entities.addElement(be); 

		BusinessDetail bd = proxy.save_business(at.getAuthInfoString(), entities);
		System.out.println("new business saved\n");

		Vector names = new Vector();
		names.add(new Name("Services Web & compagnie"));
		BusinessList bl = proxy.find_business(names, null, null, null, null, null, 0);

		BusinessInfos bis = bl.getBusinessInfos();
		if (bis.size() == 0) {
			System.out.println("no business(es) found");
		}
		else {
			System.out.println(bis.size()+" business(es) found\n");
			Vector biv = bis.getBusinessInfoVector();
			for (int i = 0; i < biv.size(); i++) {
				BusinessInfo bi = (BusinessInfo)biv.elementAt(i);
				System.out.println(bi.getNameString());
				System.out.println(bi.getBusinessKey());
				System.out.println("\n");
			}
		}
		proxy.discard_authToken(at.getAuthInfo());
	}
}